% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{ort-eigen}
\alias{ort-eigen}
\alias{ot_eigen2d}
\alias{principal_direction}
\alias{axial_strength}
\alias{axial_dispersion}
\title{Decomposition of Orientation Tensor in 2D}
\usage{
ot_eigen2d(x, w = NULL, scale = FALSE)

principal_direction(x, w = NULL)

axial_strength(x, w = NULL)

axial_dispersion(x, w = NULL)
}
\arguments{
\item{x}{numeric. Axial angular data (in degrees).}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{scale}{logical. Whether the Eigenvalues should be scaled so they sum
up to 1. Only applicable when weighting are specified,
otherwise the eigenvalues are always scaled.}
}
\value{
\code{ot_eigen2d} returns a list of the Eigenvalues and the axial angles corresponding to the Eigenvectors.
\code{principal_direction()}, \code{axial_strength()} and \code{axial_dispersion()} are convenience functions
to return the orientation of the largest eigenvalue, the orientation strength, the axial dispersion respectively.
}
\description{
Spectral decomposition of the 2D orientation tensor into two Eigenvectors and
corresponding Eigenvalues provides provides a measure of location and a
corresponding measure of dispersion, respectively.
}
\details{
The \strong{Eigenvalues} (\eqn{\lambda_1 > \lambda_2}) can be
interpreted as the fractions of the variance explained by the
orientation of the associated Eigenvectors.
The two perpendicular \strong{Eigenvectors} (\eqn{a_1, a_2}) are the "principal directions" with respect to the
highest and the lowest concentration of orientation data.

The strength of the orientation is the largest eigenvalue \eqn{\lambda_1} normalized
by the sum of the eigenvalues (\code{scale=TRUE}). Then \eqn{\lambda_2 = 1-\lambda_1} is a
\strong{measure of dispersion} of 2D orientation data with respect to \eqn{a_1}.
}
\note{
Eigenvalues and Eigenvectors of the orientation tensor (inertia tensor) are also called
"principle moments of inertia"  and "principle axes of inertia", respectively.
}
\examples{
test <- rvm(100, mean = 0, k = 10) / 2
ot_eigen2d(test)

data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
sa_eig <- ot_eigen2d(sa.por$azi.PoR, w = weighting(san_andreas$unc), scale = TRUE)
print(sa_eig)

rose(sa.por$azi.PoR, muci = FALSE)
rose_line(sa_eig$vectors,
  col = c("red", "green"),
  radius = sa_eig$values, lwd = 2
)
graphics::legend("topright",
  legend = round(sa_eig$values, 2),
  col = c("red", "green"), lty = 1
)

principal_direction(sa.por$azi.PoR)

axial_strength(sa.por$azi.PoR)

axial_dispersion(sa.por$azi.PoR)
}
\seealso{
\code{\link[=ortensor2d]{ortensor2d()}}
}
