% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_range}
\alias{circular_range}
\title{Circular Range}
\usage{
circular_range(x, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
numeric. angle in degrees
}
\description{
Length of the smallest arc which contains all the observations.
The circular range is based on the sample circular distance.
}
\examples{
roulette <- c(43, 45, 52, 61, 75, 88, 88, 279, 357)
circular_range(roulette, axial = FALSE)

data("san_andreas")
circular_range(san_andreas$azi)
}
\references{
Mardia, K.V., and Jupp, P.E (1999). Directional Statistics,
Wiley Series in Probability and Statistics. John Wiley & Sons, Inc.,
Hoboken, NJ, USA. \doi{10.1002/9780470316979}
}
\seealso{
\code{\link[=sample_circular_distance]{sample_circular_distance()}}
}
