% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_coxreg.R
\name{template_coxreg_m}
\alias{template_coxreg_m}
\title{Template: Multi-Variable Cox Regression}
\usage{
template_coxreg_m(
  dataname,
  cov_var,
  arm_var,
  cnsr_var,
  aval_var,
  ref_arm,
  comp_arm,
  paramcd,
  at = list(),
  strata_var = NULL,
  combine_comp_arms = FALSE,
  control = tern::control_coxreg(),
  na_level = tern::default_na_str(),
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{cov_var}{(\code{character})\cr names of the covariates variables.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{cnsr_var}{(\code{character})\cr name of the censoring variable.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{paramcd}{(\code{character})\cr name of the parameter code variable.}

\item{at}{(\code{list} of \code{numeric})\cr when the candidate covariate is a \code{numeric} type variable, use \code{at}
to specify the value of the covariate at which the effect should be estimated.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{combine_comp_arms}{(\code{logical})\cr triggers the combination of comparison arms.}

\item{control}{(\code{list})\cr list of settings for the analysis (see \code{\link[tern:control_coxreg]{tern::control_coxreg()}}).}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a multi-variable Cox regression analysis.
}
\seealso{
\code{\link[=template_coxreg_u]{template_coxreg_u()}}, \code{\link[=tm_t_coxreg]{tm_t_coxreg()}}
}
\keyword{internal}
