% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mindist.R
\name{mindist}
\alias{mindist}
\title{Minimizing the distance between the empirical tail and a theoretical Pareto tail with respect to k.}
\usage{
mindist(data, ts = 0.15, method = "mad")
}
\arguments{
\item{data}{vector of sample data}

\item{ts}{size of the upper tail the procedure is applied to. Default is 15 percent of the data}

\item{method}{should be one of \code{ks} for the "Kolmogorov-Smirnov" distance metric or \code{mad} for the mean absolute deviation (default)}
}
\value{
\item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
\item{threshold}{the corresponding threshold}
\item{tail.index}{the corresponding tail index by plugging in \code{k0} into the hill estimator}
}
\description{
An Implementation of the procedure proposed in Danielsson et al. (2016) for selecting the optimal threshold in extreme value analysis.
}
\details{
The procedure proposed in Danielsson et al. (2016) minimizes the distance between the largest upper order statistics of the dataset, i.e. the empirical tail, and the theoretical tail of a Pareto distribution. The parameter of this distribution are estimated using Hill's estimator. Therefor one needs the optimal number of upper order statistics \code{k}. The distance is then minimized with respect to this \code{k}. The optimal number, denoted \code{k0} here, is equivalent to the number of extreme values or, if you wish, the number of exceedances in the context of a POT-model like the generalized Pareto distribution. \code{k0} can then be associated with the unknown threshold \code{u} of the GPD by saying \code{u} is the \code{n-k0}th upper order statistic. For the distance metric in use one could choose the mean absolute deviation called \code{mad} here, or the maximum absolute deviation, also known as the "Kolmogorov-Smirnov" distance metric (\code{ks}). For more information see references.
}
\examples{
data(danish)
mindist(danish,method="mad")
}
\references{
Danielsson, J. and Ergun, L.M. and de Haan, L. and de Vries, C.G. (2016). Tail Index Estimation: Quantile Driven Threshold Selection.
}
