% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annuli.r
\name{annuli}
\alias{annuli}
\alias{disks}
\alias{sample_annulus}
\alias{sample_disk}
\title{Sample (with noise) from annuli}
\usage{
sample_annulus(n, r = 0.5, bins = 1L, sd = 0)

sample_disk(n, bins = 1L, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{r}{Minor radius of the annulus; \code{0} yields the disk.}

\item{bins}{Number of intervals per dimension to stratify by. Default set to
1, which generates a uniform sample.}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}
}
\description{
These functions generate uniform samples from annuli with in
2-dimensional space with major radius 1, optionally with noise.
}
\details{
The sample is generated by an area-preserving parameterization of
the annulus. This parameterization was derived through the method for
sampling 2-manifolds as described by Arvo (2001).
}
\examples{
set.seed(99812L)

# Uniformly sampled unit disk in 2-space
x <- sample_disk(1800, sd = 0)
plot(x, asp = 1, pch = 19, cex = .5)

# Uniformly sampled unit disk in 2-space with Gaussian noise
x <- sample_disk(1800, sd = .1)
plot(x, asp = 1, pch = 19, cex = .5)

# Uniformly sampled annulus
x <- sample_annulus(100, r = .4, sd = 0)
plot(x, asp = 1, pch = 19, cex = .5)
}
\references{
J Arvo (2001) Stratified Sampling of 2-Manifolds. \emph{SIGRAPH 2001 (State of the
Art in Monte Carlo Ray Tracing for Realistic Image Synthesis)}, Course Notes,
Vol. 29. \url{https://www.cs.princeton.edu/courses/archive/fall04/cos526/papers/course29sig01.pdf}
}
