% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_hit_AUC.R
\name{post_hit_AUC}
\alias{post_hit_AUC}
\title{Calculate Area Under the Curve After Hit-calling}
\usage{
post_hit_AUC(hit_results, return.abs = FALSE, use.log = FALSE)
}
\arguments{
\item{hit_results}{output from `tcplhit2_core`.}

\item{return.abs}{Logical argument, if TRUE, returns the absolute value of the AUC. Defaults to FALSE.}

\item{use.log}{Logical argument, defaults to FALSE. By default, the function estimates AUC with
concentrations in normal unit. If set to TRUE, will use concentration in log10-scale for
estimating AUC.}
}
\value{
AUC value of the winning model (numeric)
}
\description{
Function that calculates the area under the curve (AUC) after hit-calling.
}
\details{
This function calculates the area under the curve (AUC) for the winning model
selected during hit-calling. Wrapper function for `get_AUC`.
Designed to take the one-row output from `tcplhit2_core`, parse the model
details, and pass these values to `get_AUC` to estimate the AUC for the
winning model.
}
\examples{

conc <- c(.03, .1, .3, 1, 3, 10, 30, 100)
resp <- c(0, .2, .1, .4, .7, .9, .6, 1.2)
params <- tcplfit2_core(conc, resp, .8)
output <- tcplhit2_core(params, conc, resp, 0.8, 0.5)
post_hit_AUC(output)


}
\seealso{
get_AUC
}
