% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_n.R
\name{opt_n}
\alias{opt_n}
\title{Computes the optimal sample size for item parameter invariance tests.}
\usage{
opt_n(
  invar_obj = NULL,
  effect = NULL,
  df = NULL,
  alpha = 0.05,
  beta = 0.05,
  n_range = 10:10000
)
}
\arguments{
\item{invar_obj}{Return object of a previous call to \code{invar_test()}. Default is \code{NULL}.
If missing, values for \code{effect} and \code{df} need to be set manually.}

\item{effect}{Numeric value representing the effect size. A real number
between 0 and 1, interpreted as a proportion of pseudo-variance between persons with
different covariate values (but the same person parameter). Default is \code{NULL}.}

\item{df}{Degrees of freedom of the test. Default is \code{NULL}.}

\item{alpha}{Type I error probability. Default is 0.05.}

\item{beta}{Type II error probability. Default is 0.05.}

\item{n_range}{A numeric vector specifying the sample sizes to be evaluated. Default is \code{10:10000}).}
}
\value{
A list of two elements:
\item{opt_n}{The required sample sizes for the four tests.}
\item{real_pow}{The realized power, as the sample sizes are rounded to the next integer.}
\item{call}{The matched call.}
}
\description{
Computes the informative sample size given an effect of interest and type I and II
error probabilities (alpha and beta) for Wald (W), likelihood ratio (LR),
Rao score (RS), and gradient (GR) test.
The routine supports two modes:
 Either provide the return object of a previous call to \code{invar_test()}
 or provide the effect size of interest along with the degrees of freedom.
}
\details{
The informative sample size is the number of observations realizing a score
greater than zero and less than the maximum possible score, as these two
values are not informative for the tests.

Providing the return object of a previous call to \code{invar_test()} allows
using the results of a pilot study to obtain an empirical estimate of
parameter differences between the groups.

The default search range of \code{10:10000} should suffice for most applications.
However, if the maximum is reached, a warning is given.

If \code{effect} and \code{df} are provided, the sample sizes of all four tests will be
equal due to their asymptotic equivalence. If an \code{invar_obj} is provided,
the sample sizes will usually differ slightly.

Note: The \code{invar_test()} function currently only supports a two-group split.
}
\examples{
\dontrun{
# --- a priori mode:

  opt_n(effect=0.3,df=20)       # n=102

  opt_n(effect=0.001,df=300)    # Warning!
  opt_n(effect=0.001,df=300,n_range=1000:100000) # Warning disappears, n=91087

# --- pilot sample mode:

  library(eRm)
  opt_n(invar_test(raschdat1))

# --- typical problem: items eliminated

  ex2 = invar_test(pcmdat,model="PCM")

# The following items were excluded for the computation of GR,LR, and W
# due to inappropriate response patterns within subgroups:
I2 I4 I1 I5

> opt_n(ex2)

# Parameters:
# alpha = 0.05
# beta = 0.05
# power = 0.95
# df = 7 7 19 7                 # note the different df!

# Observed effects
#     GR     LR     RS      W
# 0.1295 0.1284 0.8462 0.1226   # note the effect differences!

# Optimal Sample Size
#  GR  LR  RS   W
# 169 170  36 178               # note the different sample sizes!
#
# Realized Power
#    GR    LR    RS     W
# 0.950 0.950 0.952 0.950
}
}
\references{
Draxler, C., & Kurz, A. (2025). Testing measurement invariance in a conditional likelihood framework by considering
multiple covariates simultaneously. \emph{Behavior Research Methods}, 57(1), 50.
}
\seealso{
\code{\link{invar_test}}, \code{\link{p_curve}}, \code{\link{p_ncurve}}
}
\keyword{sample_size_planning}
