% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{inf_tci}
\alias{inf_tci}
\title{Target-controlled infusion}
\usage{
inf_tci(
  pkmod,
  target_vals,
  target_tms,
  type = c("plasma", "effect"),
  dtm = NULL,
  custom_alg = NULL,
  inittm = 0,
  ignore_pd = FALSE,
  ...
)
}
\arguments{
\item{pkmod}{`pkmod` object created by `pkmod()` or a `poppkmod` object created by `poppkmod()`.}

\item{target_vals}{A vector of numeric values indicating PK or PD targets for TCI algorithm.}

\item{target_tms}{A vector of numeric values indicating times at which the TCI algorithm should
begin targeting each value.}

\item{type}{Type of TCI algorithm to be used. Options are plasma- or effect-site
targeting.}

\item{dtm}{TCI update frequency. Defaults to 1/6, corresponding to 10-second
intervals if model parameters are in terms of minutes.}

\item{custom_alg}{Custom TCI algorithm to be used instead of default plasma-
or effect-site targeting algorithms. The algorithm should be a function that
takes minimum arguments `Ct`, `pkmod`, and `dtm` and returns a single infusion
rate. See `tci_plasma` or `tci_effect` for examples and vignette on custom
models/algorithms for more details.}

\item{inittm}{Initial time to start TCI algorithm. Cannot be greater than
the minimum value of `target_tms`.}

\item{ignore_pd}{Logical. Should the PD component of the pkmod object (if present)
be ignored. By default, predict.tciinf will assume that 'value' refers to PD
targets if a PD model is specified.}

\item{...}{Arguments passed to TCI algorithm}
}
\description{
Apply a TCI algorithm to a set of targets and a `pkmod` or `poppkmod` object to calculate infusion
rates.
}
\examples{
# 3-compartment model with effect-site
my_mod <- pkmod(pars_pk = c(v1 = 8.995, v2 = 17.297, v3 = 120.963, cl = 1.382,
q2 = 0.919, q3 = 0.609, ke0 = 1.289))
# plasma targeting
inf_tci(my_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "plasma")
# effect-site targeting
inf_tci(my_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "effect")
# poppkmod object
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
elvd_mod <- poppkmod(data, drug = "ppf", model = "eleveld")
inf_tci(elvd_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "effect")
}
