% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tboot_bmr.R
\name{tboot_bmr}
\alias{tboot_bmr}
\title{Function tboot_bmr}
\usage{
tboot_bmr(nrow, weights_bmr, tol_rel_sd = 0.01)
}
\arguments{
\item{nrow}{Number of rows in the new bootstrapped dataset.}

\item{weights_bmr}{An object of class 'tweights_bmr' output from the 'tweights_bmr' function.}

\item{tol_rel_sd}{An error will be called if for some simulation if the target is not achievable with the data. However, the error will only be called if max absolute difference releative to the marginal standard is greater than specified.}
}
\value{
A simulated dataset with 'nrow' rows. The underlying 'true' posterior parameter value is an attribute which can be extracted useing \code{attr(ret, "post_bmr")} where 'ret' is the matrix.
}
\description{
Bootstrap \code{nrow} rows of \code{dataset} using
the given row-level weights.
}
\details{
Simulates a dataset by first simulating from the posterior distribution of the column means and then simulating a dataset with that underlying mean. Details a further documented in the vignette.
}
\examples{
#Use winsorized marginal to keep marginal simulation within feasible bootstrap region
winsor=function(marginalSims,y)  {
  l=min(y)
  u=max(y)
  ifelse(marginalSims<l,l,ifelse(marginalSims>u,u, marginalSims))
}
#Create an example marginal posterior
marginal = list(Sepal.Length=winsor(rnorm(10000,mean=5.8, sd=.2),iris$Sepal.Length),
               Sepal.Width=winsor(rnorm(10000,mean=3,sd=.2), iris$Sepal.Width),
               Petal.Length=winsor(rnorm(10000,mean=3.7,sd=.2), iris$Petal.Length)
)

#simulate
w = tweights_bmr(dataset = iris, marginal = marginal, silent = TRUE)
sample_data = tboot_bmr(1000, weights = w)

}
\seealso{
\code{\link{tweights}}
}
