% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{getId}
\alias{getId}
\title{Find a given taxa by name}
\usage{
getId(taxa, sqlFile = "nameNode.sqlite", onlyScientific = TRUE)
}
\arguments{
\item{taxa}{a vector of taxonomic names}

\item{sqlFile}{a string giving the path to a SQLite file containing a names tables}

\item{onlyScientific}{If TRUE then only match to scientific names. If FALSE use all names in database for matching (potentially increasing ambiguous matches).}
}
\value{
a vector of character strings giving taxa IDs (potentially comma concatenated for any taxa with ambiguous names)
}
\description{
Find a taxa by string in the NCBI taxonomy. Note that NCBI species are stored as Genus species e.g. "Bos taurus". Ambiguous taxa names will return a comma concatenated string e.g. "123,234" and generate a warning.
}
\examples{
namesText<-c(
  "1\t|\tall\t|\t\t|\tsynonym\t|",
  "1\t|\troot\t|\t\t|\tscientific name\t|",
  "3\t|\tMulti\t|\tBacteria <prokaryotes>\t|\tscientific name\t|",
  "4\t|\tMulti\t|\tBacteria <prokaryotes>\t|\tscientific name\t|",
  "2\t|\tBacteria\t|\tBacteria <prokaryotes>\t|\tscientific name\t|",
  "2\t|\tMonera\t|\tMonera <Bacteria>\t|\tin-part\t|",
  "2\t|\tProcaryotae\t|\tProcaryotae <Bacteria>\t|\tin-part\t|"
)
tmpFile<-tempfile()
writeLines(namesText,tmpFile)
sqlFile<-tempfile()
read.names.sql(tmpFile,sqlFile)
getId('Bacteria',sqlFile)
getId('Not a real name',sqlFile)
getId('Multi',sqlFile)
}
\seealso{
\code{\link{getTaxonomy}}, \code{\link{read.names.sql}}, \code{\link{getCommon}}
}
