% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_to_parent.R
\name{merge_to_parent}
\alias{merge_to_parent}
\alias{merge_to_parent.taxlist}
\alias{merge_to_parent,taxlist-method}
\title{Merge taxa to their respective parents}
\usage{
merge_to_parent(object, ...)

\method{merge_to_parent}{taxlist}(object, concept_id, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{taxlist}.}

\item{...}{Further arguments passed among methods.}

\item{concept_id}{A vector of IDs (TaxonConceptID) of taxa that will be
aggregated into their respective parents. Note that if one of the IDs
is simultaneously the parent of another ID in the vector, this function
will retrieve an error message.}
}
\value{
An object of class \linkS4class{taxlist} with merged taxa.
}
\description{
Aggregation of taxon concepts to their respective parents.
All names of aggregated concepts will become synonyms in the target parent.
}
\examples{
## Subset with Kyllinga species
ky <- subset(Easplist, TaxonName == "Kyllinga", keep_children = TRUE,
    keep_parents = TRUE)
ky
indented_list(ky)

## Merge two species with the genus
summary(ky, c(346, 50400))
summary(ky, "Kyllinga", exact = TRUE)
ky <- merge_to_parent(ky, c(346, 50400))

summary(ky, "Kyllinga", exact = TRUE)
}
\seealso{
\code{\link[=merge_taxa]{merge_taxa()}}
}
