% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_object.R
\name{backup_object}
\alias{backup_object}
\alias{sort_backups}
\alias{load_last}
\title{Make and load backups of R objects}
\usage{
backup_object(
  ...,
  objects = character(),
  file,
  stamp = TRUE,
  sep = "_",
  date_format = "\%Y-\%m-\%d",
  time_format = "\%H:\%M:\%S",
  overwrite = FALSE
)

sort_backups(
  name,
  path = ".",
  date_format = "\%Y-\%m-\%d",
  fext = ".rda",
  sep = "_"
)

load_last(file, path, ..., choice)
}
\arguments{
\item{...}{Names of the objects to be saved (either symbols or character
strings) in \code{backup_object()}. In \code{load_last()}, arguments passed to
\code{sort_backups()}.}

\item{objects}{A character vector indicating the names of objects to be
included in the backup file.}

\item{file}{A character value indicating the name of the backup file, without
the extension.}

\item{stamp}{A logical value indicating whether time should be stamped in the
backup name or not.}

\item{sep}{A character value used to separate backup's name from stamp and
from the suffix.}

\item{date_format}{A character value indicating the format used for the
file stamp. See \code{\link[=strptime]{strptime()}}.}

\item{time_format}{A character value indicating the format used for the
the time (not including the date), which will be used for the invisible
report in \code{backup_object()}. See \code{\link[=strptime]{strptime()}}.}

\item{overwrite}{A logical value indicating whether existing files must be
overwritten or not.}

\item{name}{A character value indicating the root of the backup's name.}

\item{path}{A character value indicating the path to the folder containing
the backup files.}

\item{fext}{A character value indicating the file extension (including the
dot symbol).}

\item{choice}{An integer value indicating the backup file to be used for
recovery. This value refers to the row in the output of \code{sort_backups()}.
If not provided, \code{load_last()} will select the newest backup.}
}
\value{
The function \code{backup_object()} writes an R-image with extension \bold{*.rda}
and an invisible vector with the name of the backup, its absolute path and
a time stamp.

The function \code{sort_backups()} returns a data frame including the sorted names
of backup files from the oldest to the newest.
}
\description{
When work with data becomes risky, the best practice is to produce backup
files.
The function of \code{backup_object} is a wrapper of \code{\link[=save]{save()}}, adding a
time stamp and a suffix to the name of the resulting file (an R image file
with extension \bold{*.rda}).
The function \code{load_last} is adapted to this style, loading the newest
version to the session.
}
\details{
In both functions the argument \code{file} may include either the path
relative to the working directory or the absolute path to the file, excluding
stamps and extension.
For \code{overwrite=FALSE} (the default), a numeric suffix will be added to
the backup's name, if another backup was produced at the same day.
For \code{overwrite=TRUE} no suffix will be included in the file and existing
files will be overwritten.

The function \code{load_last()} will load the newest version among backups
stored in the same folder, provided that the backup name includes a time
stamp.
}
\examples{
## A subset with Pseudognaphalium and relatives
Pseudognaphalium <- subset(x = Easplist, subset = grepl("Pseudognaphalium",
        TaxonName), slot = "names", keep_parents = TRUE)

## Create a backup with date stamp in tempdir
backup_object(Pseudognaphalium, file = file.path(tempdir(), "Pseudognaphalium"))

## Retrieve paths of backup
info_back <- backup_object(Pseudognaphalium, file = file.path(tempdir(),
        "Pseudognaphalium"))
info_back

## Display all backups
sort_backups("Pseudognaphalium", tempdir())

## Delete object
rm(list = "Pseudognaphalium")

## To load the last backup into a session
load_last("Pseudognaphalium", path = tempdir())

## Load pre-installed backup
load_last(file.path(path.package("taxlist"), "extdata", "Podocarpus"))
}
\seealso{
\code{\link[=save]{save()}}, \code{\link[=load]{load()}}.
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
