% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_watch.R
\name{tar_watch_app_ui}
\alias{tar_watch_app_ui}
\title{Create the full \code{\link[=tar_watch]{tar_watch()}} app UI.}
\usage{
tar_watch_app_ui(
  seconds,
  seconds_min,
  seconds_max,
  seconds_step,
  targets_only,
  outdated,
  label,
  level_separation,
  degree_from,
  degree_to,
  height,
  display,
  displays,
  title,
  theme,
  spinner
)
}
\arguments{
\item{seconds}{Numeric of length 1,
default number of seconds between refreshes of the graph.
Can be changed in the app controls.}

\item{seconds_min}{Numeric of length 1, lower bound of \code{seconds}
in the app controls.}

\item{seconds_max}{Numeric of length 1, upper bound of \code{seconds}
in the app controls.}

\item{seconds_step}{Numeric of length 1, step size of \code{seconds}
in the app controls.}

\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include global functions and objects.}

\item{outdated}{Logical, whether to show colors to distinguish outdated
targets from up-to-date targets. (Global functions and objects
still show these colors.) Looking for outdated targets
takes a lot of time for large pipelines with lots of branches,
and setting \code{outdated} to \code{FALSE} is a nice way to speed up the graph
if you only want to see dependency relationships and pipeline progress.}

\item{label}{Label argument to \code{\link[=tar_visnetwork]{tar_visnetwork()}}.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to a value chosen by \code{targets}.}

\item{degree_from}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_from}
controls the number of edges the neighborhood extends upstream.}

\item{degree_to}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_to}
controls the number of edges the neighborhood extends downstream.}

\item{height}{Character of length 1,
height of the \code{visNetwork} widget and branches table.}

\item{display}{Character of length 1, which display to show first.}

\item{displays}{Character vector of choices for the display.
Elements can be any of
\code{"graph"}, \code{"summary"}, \code{"branches"}, or \code{"about"}.}

\item{title}{Character of length 1, title of the UI.}

\item{theme}{A call to \code{\link[bslib:bs_theme]{bslib::bs_theme()}} with the \code{bslib} theme.}

\item{spinner}{\code{TRUE} to add a busy spinner, \code{FALSE} to omit.}
}
\value{
A Shiny UI.
}
\description{
Only exported for infrastructure purposes.
Not a user-side function. Users should instead
call \code{\link[=tar_watch]{tar_watch()}} directly.
}
\keyword{internal}
