% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv2struct.R
\name{csv2struct}
\alias{csv2struct}
\title{Read tag metadata from csv}
\usage{
csv2struct(fname)
}
\arguments{
\item{fname}{Name of the text file to be read. If no file extension is provided, '.csv' will be
added automatically. If the file is not located in the current working directory, then \code{fname} must include the correct relative or absolute path.}
}
\value{
a metadata list populated from \code{fname} (one list element per row in the file). All list elements are stored as \code{"character"} class objects (even if the field contains a number, a date, etc) - no attempt is made to determine the most appropriate class for each item.
}
\description{
Read a CSV metadata file and convert it into a metadata list.
A metadata file is a comma-separated text file (.csv) containing a line for each metadata
entry. The first comma-separated field in each line is the name of the
entry. The last field in each line contains the value to
be assigned to this metadata entry. The value can be a string or number
but is always saved as a string in the structure - it is up to downstream
users of the metadata to parse/decode the entries.
}
\examples{
hold <- system.file("extdata","metadata_example.csv", package = "tagtools", mustWork = TRUE)
S <- csv2struct(hold)

}
