% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_table.R
\name{add_table}
\alias{add_table}
\title{Function that adds a data frame to an (existing) .xlsx workbook sheet}
\usage{
add_table(
  Table,
  WbTitle,
  SheetTitle,
  TableTitle,
  StartRow = 1,
  StartCol = 1,
  FormatList = setNames(rep(list(Theme[["character"]]), length(colnames(Table))),
    colnames(Table)),
  Theme = xls_theme_default(),
  HeightTableTitle = 2,
  TableFootnote1 = "",
  TableFootnote2 = "",
  TableFootnote3 = "",
  MergeCol = character(0),
  ByGroup = character(0),
  GroupName = FALSE,
  asTable = FALSE
)
}
\arguments{
\item{Table}{: data frame to be exported to the workbook sheet}

\item{WbTitle}{: workbook}

\item{SheetTitle}{: string used for the sheet's name}

\item{TableTitle}{: string used for the data frame's title}

\item{StartRow}{: export start line number in the sheet (by default 1)}

\item{StartCol}{: export start column number in the sheet (by default 1)}

\item{FormatList}{: list that indicates the format of each column of the data frame}

\item{Theme}{: styling theme, a named list of `openxlsx` Styles}

\item{HeightTableTitle}{: multiplier (if needed) for the height of the title line (by default 2)}

\item{TableFootnote1}{: string for TableFootnote1}

\item{TableFootnote2}{: string for TableFootnote2}

\item{TableFootnote3}{: string for TableFootnote3}

\item{MergeCol}{: character vector that indicates the columns for which to merge the modalities}

\item{ByGroup}{character vector indicating the name of the columns by which to group}

\item{GroupName}{boolean indicating whether the name of the grouping variable should be written}

\item{asTable}{logical indicating if data should be written as an Excel Table (FALSE by default)}
}
\value{
excel wb object
}
\description{
Function that adds a data frame to an (existing) .xlsx workbook sheet
}
