% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{getRowRepo.tableMatrix}
\alias{getRowRepo.tableMatrix}
\title{Get row repo}
\usage{
\method{getRowRepo}{tableMatrix}(obj, i = NULL, repo = NULL, ...)
}
\arguments{
\item{obj}{\code{tableMatrix} object.}

\item{i}{Integer. Row index in \code{tab}.}

\item{repo}{Numeric vector. Vector with 2 elements - matN and matRow.}

\item{...}{Passed arguments.}
}
\value{
Vector of matN and matRow.
}
\description{
\code{tableMatrix} method to get row repo (vector of matN and matRow) for the matrix attribute
}
\examples{

data(images8By8)
data(images10By10)

# Create tableMatrix from images8By8 and images10By10
TM <- tableMatrix(list(images8By8, images10By10), list(1:3, 1:3),
list(c(4:ncol(images8By8)),c(4:ncol(images10By10))))
tab(TM)

# Row 2 in tab(TM) corresponds to first matrix, second row 
getRowRepo(TM, 2)

# Row 91 in tab(TM) corresponds to second matrix, first row 
getRowRepo(TM, 91)

}
