% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GelfandTsetlin.R
\name{GelfandTsetlinPatterns}
\alias{GelfandTsetlinPatterns}
\title{Gelfand-Tsetlin patterns}
\usage{
GelfandTsetlinPatterns(lambda, weight)
}
\arguments{
\item{lambda}{integer partition; up to trailing zeros, this will be the 
top diagonal of the generated Gelfand-Tsetlin patterns}

\item{weight}{integer vector; the partial sums of this vector will be the 
diagonal sums of the generated Gelfand-Tsetlin patterns}
}
\value{
A list of Gelfand-Tsetlin patterns. A Gelfand-Tsetlin pattern is a 
  triangular array of non-negative integers, and it is represented by the 
  list of its rows. Hence the first element of this list is an integer, the 
  second element is an integer vector of length two, and so on. The length 
  of this list is the length of \code{weight}.
}
\description{
Enumeration of Gelfand-Tsetlin patterns defined by a given
  integer partition and a given weight.
}
\examples{
GTpatterns <- GelfandTsetlinPatterns(c(3, 1), c(1, 1, 1, 1))
lapply(GTpatterns, prettyGT)
}
\seealso{
\code{\link{skewGelfandTsetlinPatterns}}.
}
