% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syrup.R
\name{syrup}
\alias{syrup}
\title{Memory and CPU Usage Information for Parallel R Code}
\usage{
syrup(expr, interval = 0.5, peak = FALSE, env = caller_env())
}
\arguments{
\item{expr}{An expression.}

\item{interval}{The interval at which to take snapshots of respirce usage.
In practice, there's an overhead on top of each of these intervals.}

\item{peak}{Whether to return rows for only the "peak" memory usage.
Interpreted as the \code{id} with the maximum \code{rss} sum. Defaults to \code{FALSE},
but may be helpful to set \code{peak = TRUE} for potentially very long-running
processes so that the tibble doesn't grow too large.}

\item{env}{The environment to evaluate \code{expr} in.}
}
\value{
A tibble with columns \code{id} and \code{time} and a number of columns from
\code{\link[ps:ps]{ps::ps()}} output describing memory and CPU usage. Notably, the process ID
\code{pid}, parent process ID \code{ppid}, percent CPU usage, and resident set size
\code{rss} (a measure of memory usage).
}
\description{
This function is a wrapper around the system command \code{ps} that can
be used to benchmark (peak) memory and CPU usage of parallel R code.
By taking snapshots the memory usage of R processes at a regular \code{interval},
the function dynamically builds up a profile of their usage of system
resources.
}
\details{
While much of the verbiage in the package assumes that the supplied
expression will be distributed across CPU cores, there's nothing specific
about this package that necessitates the expression provided to \code{syrup()} is
run in parallel. Said another way, \code{syrup()} will work just fine
with "normal," sequentially-run R code (as in the examples). That said,
there are many better, more fine-grained tools for the job in the case of
sequential R code, such as \code{\link[=Rprofmem]{Rprofmem()}}, the
\href{https://CRAN.R-project.org/package=profmem}{profmem}
package, the \link[bench:mark]{bench} package, and packages in
the \href{https://github.com/r-prof}{R-prof} GitHub organization.

Loosely, the function works by:
\itemize{
\item Setting up another R process (call it \code{sesh}) that queries system
information using \code{\link[ps:ps]{ps::ps()}} at a regular interval,
\item Evaluating the supplied expression,
\item Reading the queried system information back into the main process from \code{sesh},
\item Closing \code{sesh}, and then
\item Returning the queried system information.
}

Note that information on the R process \code{sesh} is filtered out from the results
automatically.
}
\examples{
\dontshow{if (ps::ps_os_type()[["POSIX"]] && !syrup:::is_fedora()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# pass any expression to syrup. first, sequentially:
res_syrup <- syrup({res_output <- Sys.sleep(1)})

res_syrup

# to snapshot memory and CPU information more (or less) often, set `interval`
syrup(Sys.sleep(1), interval = .01)

# use `peak = TRUE` to return only the snapshot with
# the highest memory usage (as `sum(rss)`)
syrup(Sys.sleep(1), interval = .01, peak = TRUE)

# results from syrup are more---or maybe only---useful when
# computations are evaluated in parallel. see package README
# for an example.
\dontshow{\}) # examplesIf}
}
