% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve}
\alias{solve}
\alias{solve,DenseMatrix-method}
\alias{solve,VecBasic-method}
\alias{solve,Basic-method}
\title{Solve Symbolic Equations}
\usage{
solve(a, b, ...)

\S4method{solve}{DenseMatrix}(a, b, ...)

\S4method{solve}{VecBasic}(a, b, ...)

\S4method{solve}{Basic}(a, b, ...)
}
\arguments{
\item{a, b}{Objects, see details.}

\item{...}{Not used.}
}
\value{
A \code{VecBasic} or \code{DenseMatrix} S4 object.
}
\description{
Solve system of symbolic equations or solve a polynomial equation.
Depending on types of arguments, it supports different modes.
See Details and Examples.
}
\details{
\code{solve} is a generic function dispatched on the class of the first argument.
\itemize{
  \item{
    If \code{a} is a (square) DenseMatrix, it solves the equation
    \code{a \%*\% x = b} for \code{x}. (similar to \code{solve.default()})
  }
  \item{
    If \code{a} is a DenseMatrix and \code{b} is missing, \code{b} is
    taken to be an identity matrix and \code{solve} will return the
    inverse of \code{a}. (similar to \code{solve.default()})
  }
  \item{
    If \code{a} is a VecBasic, it solves the system of linear equations
    represented by \code{a} with regards to symbols represented in \code{b}.
  }
  \item{
    If \code{a} is a Basic, it solves the polynomial equation represented by
    a with regards to the symbol represented in \code{b}.
  }
}
}
\examples{
## Inverse of a symbolic matrix
mat <- Matrix(c("A", "B", "C", "D"), 2)
solve(mat)

## Solve a \%*\% x == b
a <- Matrix(c("a11", "a21", "a12", "a22"), 2) # a is a 2x2 matrix
b <- Vector("b1", "b2")                       # b is a length 2 vector
solve(a, b)                                   # Solution of x (2x1 matrix)

## Solve the system of linear equations represented by a with regards to
## symbols in b
a <- Vector(~ -2*x + y - 4,  # A system of linear equations
            ~  3*x + y - 9)
b <- Vector(~x, ~y)          # Symbols to solve (x and y)
solve(a, b)                  # Solution of x and y
}
