% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-ase.R
\name{read_ase}
\alias{read_ase}
\title{Read colors from Adobe Swatch Exchange (ASE) files}
\usage{
read_ase(path, use_names = TRUE, .verbose = FALSE)
}
\arguments{
\item{path}{partial or full file path or URL to an ASE file}

\item{use_names}{add color names to the vector (defaults to \code{TRUE}). See NOTE}

\item{.verbose}{show extra information about ASE file processing}
}
\description{
Given a path or URL to an \code{.ase} file, this function will return
a named character vector (if color names are present) of hex RGB colors.
}
\note{
When using named color palettes in a \code{ggplot2} \code{scale_} context, you
    must \code{unname}, set \code{use_names} to \code{FALSE} or override their names
    to map to your own factor levels. Also, Neither Lab nor greyscale colors are supported.
}
\examples{
# built-in palette
keep_the_change <- read_ase(system.file("palettes", "keep_the_change.ase", package="swatches"))
print(keep_the_change)
show_palette(keep_the_change)

# from the internet directly
\dontrun{
github <- "https://github.com/picwellwisher12pk/en_us/raw/master/Swatches/Metal.ase"
metal <- read_ase(github)
print(metal)
show_palette(metal)
}
}
