% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{read_svg}
\alias{read_svg}
\title{Read SVG file and return XML document}
\usage{
read_svg(file, enc = "UTF-8", summary = FALSE, display = FALSE)
}
\arguments{
\item{file}{A string, a connection, or a raw vector. See \code{\link[xml2]{read_xml}}.}

\item{enc}{Encoding (default 'UTF-8').}

\item{summary}{Show summary of SVG file (\code{\link{summary_svg}})? (default FALSE)}

\item{display}{Display SVG on standard display port (\code{\link{display_svg}})? (default FALSE)}
}
\value{
XML document with SVG content
}
\description{
Read SVG file and return XML document
}
\examples{
fpath <- system.file("extdata", "fig1.svg", package="svgtools")
svg <- read_svg(file = fpath, summary = TRUE)
}
