% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_transformers_numeric.R
\name{transformers.numeric}
\alias{transformers.numeric}
\alias{eq}
\alias{neq}
\alias{inbetw}
\alias{ninbetw}
\alias{gt}
\alias{ngt}
\alias{gte}
\alias{ngte}
\alias{lt}
\alias{nlt}
\alias{lte}
\alias{nlte}
\title{Utility Functions for numeric operator selection}
\usage{
eq(value_set)

neq(value_set)

inbetw(value_set)

ninbetw(value_set)

gt(value_set)

ngt(value_set)

gte(value_set)

ngte(value_set)

lt(value_set)

nlt(value_set)

lte(value_set)

nlte(value_set)
}
\arguments{
\item{value_set}{the parameter set for the operator}
}
\value{
a list with a single named element (operator name) to be handed over to the filter.
}
\description{
Can be used in filters ("where") for operator selection. If none is selected, operator always defaults to `eq()`. The functions bellow are
valid for the corresponding inputs ComparableInt64OperationFilterInput and ComparableNullableOfInt32OperationFilterInput.
}
\details{
Also see the \link{susoop_num} selector list, which allows you, to just select the function from
a named list.
}
\section{Functions}{
\itemize{
\item \code{eq()}: equal

\item \code{neq()}: not equal

\item \code{inbetw()}: inbetween (requires numeric vector with upper and lower bound, i.e. c(1, 5))

\item \code{ninbetw()}: not inbetween (requires numeric vector with upper and lower bound, i.e. c(1,5))

\item \code{gt()}: greater than

\item \code{ngt()}: not greater than

\item \code{gte()}: greater than or equal

\item \code{ngte()}: not greater than or equal

\item \code{lt()}: lower than

\item \code{nlt()}: not lower than

\item \code{lte()}: lower than or equal

\item \code{nlte()}: not lower than or equal

}}
\examples{

# set filter equal to 0
eq(0)

# set filter to a value from 0 to 5
inbetw(c(0, 5))

}
