% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isascii.R
\name{strs_isascii}
\alias{strs_isascii}
\title{Check if string contains only ascii characters}
\usage{
strs_isascii(string)
}
\arguments{
\item{string}{A character vector to be checked.}
}
\value{
A logical vector of the same length as \code{string}, indicating whether
each element contains only ASCII characters.
}
\description{
\code{strs_isascii} determines whether each element of a character vector contains
only ASCII characters. It is similar to Python's \code{str.isascii()} method.
}
\examples{
strs_isascii("hello")
strs_isascii("héllo")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.isascii}{Python str.isascii() documentation}
}
