% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-by-nums.R
\name{str_split_by_numbers}
\alias{str_split_by_numbers}
\title{Split a string by its numeric characters.}
\usage{
str_split_by_numbers(
  string,
  decimals = FALSE,
  leading_decimals = FALSE,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  commas = FALSE
)
}
\arguments{
\item{string}{A string.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{big_mark}{A character. Allow this character to be used as a thousands
separator. This character will be removed from between digits before they
are converted to numeric. You may specify many at once by pasting them
together e.g. \code{big_mark = ",_"} will allow both commas and underscores.
Internally, this will be used inside a \verb{[]} regex block so e.g. \code{"a-z"}
will behave differently to \code{"az-"}. Most common separators (commas, spaces,
underscores) should work fine.}

\item{commas}{Deprecated. Use \code{big_mark} instead.}
}
\value{
A list of character vectors.
}
\description{
Break a string wherever you go from a numeric character to a non-numeric or
vice-versa. Keep the whole string, just split it up. Vectorised over
\code{string}.
}
\examples{
str_split_by_numbers(c("abc123def456.789gh", "a1b2c344"))
str_split_by_numbers("abc123def456.789gh", decimals = TRUE)
str_split_by_numbers(c("22", "1.2.3"), decimals = TRUE)
}
\seealso{
Other splitters: 
\code{\link{str_split_camel_case}()}
}
\concept{splitters}
