% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_x_index.R
\name{local_x_index}
\alias{local_x_index}
\alias{local_max_index}
\alias{local_min_index}
\title{Find indexed local minima/maxima}
\usage{
local_max_index(
  dates,
  values,
  look_behind = 2,
  look_ahead = 2,
  look_units = "days"
)

local_min_index(
  dates,
  values,
  look_behind = 2,
  look_ahead = 2,
  look_units = "days"
)
}
\arguments{
\item{dates}{A vector of dates of 'Date' class. There are 2 restrictions:
\itemize{
\item The vector must be in ascending order; duplicates are allowed
\item The vector cannot have missing values (i.e., no NA)
}}

\item{values}{A vector of numeric values. The values must be in correspondence with \code{dates},
meaning the \emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{look_behind, look_ahead}{The number of \code{look_units} before and after the center date to
include in the sliding window to determine local maxima or minima.}

\item{look_units}{One of "days", "weeks", or "months". The units to give \code{look_ahead} and
\code{look_behind}.}
}
\value{
A logical vector with the same length as \code{dates} and \code{values}.
}
\description{
Identify local minima or maxima of a vector across a sliding date window. Intended to be used on
a (near) daily water quality record.
}
\details{
The size of the moving window is adjusted to be shorter at the ends of a record. For example, at
the start of a record only the first element of the record plus the values included in the
\code{look_ahead} are evaluated.

Any object that can be added or subtracted from the \code{dates} with \code{+} and \code{-} can be used for
\code{look_behind} and \code{look_ahead}. By default, these are both \code{2} days. This creates a 5-day sliding
window where the 3rd day is the element evaluated.

If an element in \code{values} is \code{NA}, then \code{FALSE} is returned. If a group of elements within a
window is all \code{NA}, then \code{FALSE} is returned.
}
\examples{
# Works as expected
date_vec <- seq.Date(
  from = as.Date("2020-01-01"), 
  to = as.Date("2020-01-06"), 
  by = "day"
)
num_vec <- c(10, 11, 50, 9, 8, 100)

results <- local_max_index(
  dates = date_vec, 
  values = num_vec
)
print(data.frame(
  "date" = date_vec, 
  "value" = num_vec, 
  "local_max" = results
))

# Different look_ahead/behind
date_vec <- seq(
  from = as.Date("2020-01-01"), 
  to = as.Date("2020-02-01"), 
  by = "day"
)
set.seed(123)
num_vec <- sample(30:300, length(date_vec), replace = TRUE)

results <- local_max_index(
  dates = date_vec, 
  values = num_vec, 
  look_behind = 1, 
  look_ahead = , 
  look_units = "days"
)
print(data.frame(
  "date" = date_vec, 
  "value" = num_vec, 
  "local_max" = results
))
}
