% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{CodeChunk}
\alias{CodeChunk}
\title{A executable chunk of code.}
\usage{
CodeChunk(
  text,
  alters,
  assigns,
  caption,
  declares,
  duration,
  errors,
  exportFrom,
  format,
  id,
  importTo,
  imports,
  label,
  meta,
  outputs,
  programmingLanguage,
  reads,
  uses
)
}
\arguments{
\item{text}{The text of the code. \bold{Required}.}

\item{alters}{Names of variables that the code chunk alters.}

\item{assigns}{Variables that the code chunk assigns to.}

\item{caption}{A caption for the CodeChunk.}

\item{declares}{Variables that the code chunk declares.}

\item{duration}{Duration in seconds of the last execution of the chunk.}

\item{errors}{Errors when compiling or executing the chunk.}

\item{exportFrom}{A compilation directive giving the name of the variable to export into the content of the code block.}

\item{format}{Media type, typically expressed using a MIME format, of the code.}

\item{id}{The identifier for this item.}

\item{importTo}{A compilation directive giving the name of the variable to import the content of the code block as.}

\item{imports}{Software packages that the code chunk imports}

\item{label}{A short label for the CodeChunk.}

\item{meta}{Metadata associated with this item.}

\item{outputs}{Outputs from executing the chunk.}

\item{programmingLanguage}{The programming language of the code.}

\item{reads}{Filesystem paths that this code chunk reads from.}

\item{uses}{Names of variables that the code chunk uses (but does not alter).}
}
\value{
A \code{list} of class \code{CodeChunk}
}
\description{
A executable chunk of code.
}
\examples{
CodeChunk(
  programmingLanguage = "r",
  text = "plot(1)",
  label = "Figure 1",
  id = "fig1",
  caption = list(
    Heading(
      content = list("Figure title"),
      depth = 2
    ),
    Paragraph(
      content = list(
        "A paragraph with some",
        Strong(content = list("strong emphasis")),
        "in it."
      )
    )
  )
)
}
\seealso{
\code{\link{CodeBlock}}
}
