% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoringTable.R
\name{import_ScoringTable}
\alias{import_ScoringTable}
\title{Import ScoringTable}
\usage{
import_ScoringTable(
  source,
  method = c("csv", "json", "object"),
  cond_file,
  conditions
)
}
\arguments{
\item{source}{Path to the file to import the \code{ScoringTable} from (for \emph{csv} and \emph{json} methods)
or \code{ScoringTable} in form of \code{data.frame} (for \emph{object} method)}

\item{method}{Method for import, either \emph{csv}, \emph{json} or \emph{object}}

\item{cond_file}{File to import the \code{GroupConditions} from, if using \emph{csv} method}

\item{conditions}{\code{GroupCondition} object or list of up to two of them. Mandatory
for \emph{object} method and \emph{csv} method if no \code{cond_file} is provided. If provided
while using \emph{json} method, original \code{GroupConditions} will be ignored.}
}
\value{
\code{ScoringTable} object
}
\description{
\code{ScoringTable} can be imported from \code{csv}, \code{json} file or
\code{tibble}. Source file or object can be either an output of \code{\link[=export_ScoringTable]{export_ScoringTable()}}
function, or created by hand - though it needs to be created following the
correct format.
}
\examples{
# Scoring table to export / import #

Consc_ST <- 
  GroupedFrequencyTable(
    data = IPIP_NEO_300,
    conditions = GroupConditions("Sex", "M" ~ sex == "M", "F" ~ sex == "F"), 
    var = "C") |>
  GroupedScoreTable(scale = STEN) |>
  to_ScoringTable(min_raw = 60, max_raw = 300)

#### Export/import method: csv ####

scoretable_csv <- tempfile(fileext = ".csv")
conditions_csv <- tempfile(fileext = ".csv")

export_ScoringTable(
  table = Consc_ST,
  out_file = scoretable_csv,
  method = "csv",
  cond_file = conditions_csv
)

## check if these are regular csv files
writeLines(head(readLines(scoretable_csv)))
writeLines(head(readLines(conditions_csv)))

imported_from_csv <- import_ScoringTable(
  source = scoretable_csv,
  method = "csv",
  cond_file = conditions_csv
)

all.equal(Consc_ST, imported_from_csv)

#### Export/import method: json ####
scoretable_json <- tempfile(fileext = ".json")

export_ScoringTable(
  table = Consc_ST,
  out_file = scoretable_json,
  method = "json"
)

## check if this is regular json file
writeLines(head(readLines(scoretable_json)))

imported_from_json <- import_ScoringTable(
  source = scoretable_json,
  method = "json"
)

all.equal(Consc_ST, imported_from_json)
}
\seealso{
export_ScoringTable

Other import/export functions: 
\code{\link{export_ScaleSpec}()},
\code{\link{export_ScoringTable}()},
\code{\link{import_ScaleSpec}()}
}
\concept{import/export functions}
