% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoringTable.R
\name{to_ScoringTable}
\alias{to_ScoringTable}
\alias{to_ScoringTable.ScoreTable}
\alias{to_ScoringTable.GroupedScoreTable}
\alias{summary.ScoringTable}
\title{Create ScoringTable}
\usage{
to_ScoringTable(table, ...)

\method{to_ScoringTable}{ScoreTable}(
  table,
  scale = NULL,
  min_raw = NULL,
  max_raw = NULL,
  score_colname = "Score",
  ...
)

\method{to_ScoringTable}{GroupedScoreTable}(table, scale = NULL, min_raw = NULL, max_raw = NULL, ...)

\method{summary}{ScoringTable}(object, ...)
}
\arguments{
\item{table}{\code{ScoreTable} or \code{GroupedScoreTable} object}

\item{...}{further arguments passed to or from other methods.}

\item{scale}{name of the scale attached in \code{table}. If only one
scale is attached, it can be left as default \code{NULL}}

\item{min_raw, max_raw}{absolute minimum/maximum score that can be received.
If left as default \code{NULL}, the minimum/maximum available in the data will be
used.}

\item{score_colname}{Name of the column containing the raw scores}

\item{object}{\code{ScoringTable} object}
}
\value{
\code{ScoringTable} object
}
\description{
ScoringTable is a simple version of \code{\link[=ScoreTable]{ScoreTable()}} or \code{\link[=GroupedScoreTable]{GroupedScoreTable()}},
that don't include the \code{FrequencyTable} internally. It can be easily
saved to \code{csv} or \code{json} using \code{\link[=export_ScoringTable]{export_ScoringTable()}} and loaded from these
files using \code{\link[=import_ScoringTable]{import_ScoringTable()}}.

When using \code{GroupedScoreTable}, the columns will be named the same as the
name of group. If it was created using two \code{GroupCondition} object, the names
of columns will be names of the groups seperated by \code{:}
}
\examples{
Extr_ST <- 
  # create FrequencyTable
  FrequencyTable(data = IPIP_NEO_300$E) |>
  # create ScoreTable
  ScoreTable(scale = STEN) |>
  # and transform into ScoringTable
  to_ScoringTable(
    min_raw = 60,
    max_raw = 300
  )

summary(Extr_ST)
#### GroupConditions creation ####

sex_grouping <- GroupConditions(
  conditions_category = "Sex",
  "Male" ~ sex == "M",
  "Female" ~ sex == "F"
)

####   Creating ScoringTable   #### 
##     based on grouped data     ##

Neu_ST <- 
  # create FrequencyTable
  GroupedFrequencyTable(
    data = IPIP_NEO_300,
    conditions = sex_grouping, 
    var = "N") |>
  # create ScoreTable
  GroupedScoreTable(
    scale = STEN) |>
  # and transform into ScoringTable
  to_ScoringTable(
    min_raw = 60,
    max_raw = 300
  )

summary(Neu_ST)
}
