% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_lgl_ish.R
\name{are_lgl_ish}
\alias{are_lgl_ish}
\alias{is_lgl_ish}
\alias{are_lgl_ish.default}
\title{Check if an object can be safely coerced to logical}
\usage{
are_lgl_ish(x, ...)

is_lgl_ish(x, ...)

\method{are_lgl_ish}{default}(x, ..., depth = 1)
}
\arguments{
\item{x}{The object to check.}

\item{...}{Arguments passed to methods.}

\item{depth}{\verb{(length-1 integer)} Current recursion depth. Do not manually
set this parameter.}
}
\value{
\code{are_lgl_ish()} returns a logical vector with the same length as the
input. \code{is_lgl_ish()} returns a \verb{length-1 logical} (\code{TRUE} or \code{FALSE}) for
the entire vector.
}
\description{
\code{are_lgl_ish()} is a vectorized predicate function that checks whether each
element of its input can be safely coerced to a logical vector.

\code{is_lgl_ish()} is a scalar predicate function that checks if all elements of
its input can be safely coerced to a logical vector.
}
\examples{
are_lgl_ish(c(TRUE, FALSE, NA))
is_lgl_ish(c(TRUE, FALSE, NA))

are_lgl_ish(c(1, 0, 1.0, NA))
is_lgl_ish(c(1, 0, 1.0, NA))

are_lgl_ish(c("T", "F", "TRUE", "FALSE", "true", "false", "1", "0"))
is_lgl_ish(c("T", "F", "TRUE", "FALSE", "true", "false", "1", "0"))

are_lgl_ish(c("T", "F", "a", "1.1"))
is_lgl_ish(c("T", "F", "a", "1.1"))

are_lgl_ish(factor(c("T", "a")))
is_lgl_ish(factor(c("T", "a")))

are_lgl_ish(list(TRUE, 0, "F", "a"))
is_lgl_ish(list(TRUE, 0, "F", "a"))
}
