% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1way.R
\name{anova1way}
\alias{anova1way}
\title{One-Way ANOVA}
\usage{
anova1way(k = 3,n , mean = 0, sigma = 1,
          coefvar = NULL, method = c("Tukey", "LSD", "Dunnett", "Bonferroni", "Scheffe"),
          conf.level = 0.95, dec = 2)
}
\arguments{
\item{k}{number of levels. By default k = 3.}

\item{n}{size of samples.}

\item{mean}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{coefvar}{an optional vector of coefficients of variation.}

\item{method}{post-hoc method applied. There are five possible choices: "\code{Tukey}", "\code{LSD}", "\code{Dunnett}", "\code{Bonferroni}", "\code{Scheffe}". Can be specified just the initial letter.}

\item{conf.level}{confidence level of the interval.}

\item{dec}{number of decimals for observations.}
}
\value{
List containing the following components:

\itemize{

 \item \code{Data}: a data frame containing the samples created.

 \item \code{Anova}: anova fitted model.

 \item \code{Significance}: significance of the factor.

 \item \code{Size.effect}: size effect of the factor.

 \item \code{Test Post-Hoc}: test Post-Hoc.
}
}
\description{
\code{anova1way} is used to generate multivariate data in order to compute analysis of variance with 1 factor. It provides balanced and unbalanced ANOVA (as long as homogeneity of variances is satisfied. In other case it is provided Welch test).
}
\details{
If \code{mean} or \code{sigma} are not specified it is assumed the default values of \code{0} and \code{1}.

    If \code{coefvar} (= \code{sigma}/\code{mean}) is specified, function omits \code{sigma}.

    Number of samples is choosen by \code{k} (by default k = 3). Therefore, if the others parameters (\code{n}, \code{mean}, \code{sigma}, \code{coefvar}) have not same length, function \code{rep} will be used. Pay attention if vectors dont have same length.

    Moreover, not only gives samples for each level, but also the ANOVA table and post-hoc test (in case of significance). By default \code{conf.level} = 0.95 and Tukey method is used. If the homogeneity of variances is not verified (using Bartlett test), the Welch test is performed.
}
\examples{
anova1way(k=4,n=c(40,31,50),mean=c(55,52,48,59),coefvar=c(0.12,0.15,0.13),conf.level = 0.99)

anova1way(k=3,n=15,mean=c(10,15,20),sigma =c(1,1.25,1.1),method ="B")


}
