% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.equiv.prop2}
\alias{size.equiv.prop2}
\title{Sample size for a 2-group proportion equivalence test}
\usage{
size.equiv.prop2(alpha, pow, p1, p2, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{h}{upper limit for range of practical equivalence}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes) required
to perform an equivalence test for the difference in population proportions
with desired power in a 2-group design. The value of h specifies a range of
practical equivalence, -h to h, for the difference in population proportions.
The absolute difference in the proportion planning values must be less than h.
Equivalence tests often require a very large sample size. Equivalence tests
usually use 2 x alpha rather than alpha (e.g., use alpha = .10 rather than
alpha = .05). This function sets the effect size equal to the difference in
proportion planning values.

For more details, see Section 2.23 of Bonett (2021, Volume 3)
}
\examples{
size.equiv.prop2(.1, .9, .8, .8, .075)

# Should return:
# Sample size per group
#                   488


}
\references{
\insertRef{Bonett2021}{statpsych}
}
