% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproductionFunction.R
\name{reproFuncDefault}
\alias{reproFuncDefault}
\alias{reproFunc}
\alias{reproductionFunction}
\title{Reproduction Function}
\usage{
reproFuncDefault(x, time, species, strain)
}
\arguments{
\item{x}{Vector of state variables within the DDE solver. To access a variable use:
x$speciesName['stageName',strainNumber]
e.g. for species 'Bacteria', stage 'reproductive', strain 2 use
x$Bacteria['reproductive',2]
If there is only one stage and strain in species 'Food', for example, use
x$Food[1,1]}

\item{time}{(scalar). The current time point in the DDE solver.}

\item{species}{(integer). The numbered species for which to return a reproductive rate.}

\item{strain}{(integer). The numbered strain for which to return a rate.}
}
\value{
Reproduction rate (amount per unit time) for the strain, species and time specified.
}
\description{
Return the rate of reproduction (amount per unit time)
}
\details{
Unlike the other \code{\link{RateFunctions}} this rate function has
no stage argument as by definition it only pertains to the first
stage of life
}
