% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_text.R
\name{color_plot}
\alias{color_plot}
\title{Plot color examples with contrasting text}
\usage{
color_plot(
  colors,
  labels = TRUE,
  borders = NULL,
  cex_label = 1,
  ncol = NULL,
  ...
)
}
\arguments{
\item{colors}{Vector of colors to plot}

\item{labels}{Show color names. Default is TRUE}

\item{borders}{Border parameter for 'rect()' function. Default is NULL}

\item{cex_label}{Label size. Default is 1.}

\item{ncol}{Desired number of columns. Default is ceiling of square root to
the length of 'colors' vector provided.}

\item{...}{Parameters for the}
}
\value{
base plot
}
\description{
Plots color examples with contrasting text. Parameters are passed to
contrast_text.
}
\examples{
par(bg=NULL)
colors <- sample(colors(),size = 20)
color_plot(colors, method="relative")

}
