#' Grocery and supermarkets turnover
#'
#' Turnover of supermarkets and grocery stores in New South Wales, Australia.
#'
#' @docType data
#'
#' @usage grocery
#'
#' @format An object of class \code{ts}.
#'
#' @keywords datasets
#'
#' @references Australian Bureau of Statistics, CAT 8501.0.
#' (\href{https://www.abs.gov.au/AUSSTATS/abs@.nsf/DetailsPage/8501.0Jun%202016?OpenDocument}{TABLE 11. Retail Turnover, State by Industry Subgroup,
#' Original})
#'
#' @examples
#' plot(grocery, ylab = "NSW Grocery, $ 10^6")
"grocery"

# @source \href{http://www.abs.gov.au/ausstats/meisubs.NSF/log?openagent&8501011.xls&8501.0&Time%20Series%20Spreadsheet&6D0A6496103804BACA2580040013D08C&0&Jun%202016&04.08.2016&Latest}
# @source \href{http://www.abs.gov.au/AUSSTATS/abs@.nsf/DetailsPage/8501.0Jun%202016?OpenDocument}
#
