% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooths.R
\name{smooth_time}
\alias{smooth_time}
\alias{smooth_space}
\alias{smooth_space_time}
\alias{smooth_lag}
\alias{smooth_time,sf,sspm_discrete_boundary-method}
\alias{smooth_space,sf,sspm_discrete_boundary-method}
\alias{smooth_space_time,sf,sspm_discrete_boundary-method}
\alias{smooth_lag,ANY,sf,sspm_discrete_boundary-method}
\title{sspm Smoothing functions}
\usage{
smooth_time(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = NULL,
  bs = "re",
  xt = NA,
  is_spm = FALSE,
  ...
)

smooth_space(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = NULL,
  bs = "mrf",
  xt = NULL,
  is_spm = FALSE,
  ...
)

smooth_space_time(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = c(NA, 30),
  bs = c("re", "mrf"),
  xt = list(NA, NULL),
  is_spm = FALSE,
  ...
)

smooth_lag(
  var,
  data_frame,
  boundaries,
  time,
  type = "LINPRED",
  k = 5,
  m = 1,
  ...
)

\S4method{smooth_time}{sf,sspm_discrete_boundary}(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = NULL,
  bs = "re",
  xt = NA,
  is_spm = FALSE,
  ...
)

\S4method{smooth_space}{sf,sspm_discrete_boundary}(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = NULL,
  bs = "mrf",
  xt = NULL,
  is_spm = FALSE,
  ...
)

\S4method{smooth_space_time}{sf,sspm_discrete_boundary}(
  data_frame,
  boundaries,
  time,
  type = "ICAR",
  k = c(NA, 30),
  bs = c("re", "mrf"),
  xt = list(NA, NULL),
  is_spm = FALSE,
  ...
)

\S4method{smooth_lag}{ANY,sf,sspm_discrete_boundary}(
  var,
  data_frame,
  boundaries,
  time,
  type = "LINPRED",
  k = 5,
  m = 1,
  ...
)
}
\arguments{
\item{data_frame}{\strong{[sf data.frame]} The data.}

\item{boundaries}{\strong{[sspm_boundary]} An object of class
\link[=sspm_boundary-class]{sspm_discrete_boundary}.}

\item{time}{\strong{[character]} The time column.}

\item{type}{\strong{[character]} Type of smooth, currently only "ICAR" is
supported.}

\item{k}{\strong{[numeric]} Size of the smooths and/or size of the lag.}

\item{bs}{a two letter character string indicating the (penalized) smoothing basis to use.
(eg \code{"tp"} for thin plate regression spline, \code{"cr"} for cubic regression spline).
see \code{\link[mgcv]{smooth.terms}} for an over view of what is available.
}

\item{xt}{Any extra information required to set up a particular basis. Used
  e.g. to set large data set handling behaviour for \code{"tp"} basis. If \code{xt$sumConv}
  exists and is \code{FALSE} then the summation convention for matrix arguments is turned off. }

\item{is_spm}{Whether or not an SPM is being fitted (used internally)}

\item{...}{ a list of variables that are the covariates that this
    smooth is a function of. Transformations whose form depends on
    the values of the data are best avoided here: e.g. \code{s(log(x))}
    is fine, but \code{s(I(x/sd(x)))} is not (see \code{\link[mgcv]{predict.gam}}).}

\item{var}{\strong{[symbol]} Variable (only for smooth_lag).}

\item{m}{The order of the penalty for this term (e.g. 2 for
    normal cubic spline penalty with 2nd derivatives when using 
   default t.p.r.s basis). \code{NA} signals
    autoinitialization. Only some smooth classes use this. The \code{"ps"} 
    class can use a 2 item array giving the basis and penalty order separately.}
}
\value{
A list of 2 lists:
\itemize{
\item \code{args}, contains the arguments to be passed on to the mgcv smooths
\item \code{vars}, contains variables relevant to the evaluation of the smooth.
}
}
\description{
A full sspm formula contains calls to the smoothing terms \code{smooth_time()},
\code{smooth_space()}, \code{smooth_space_time()}.
}
\examples{
\dontrun{
# Not meant to be used directly
smooth_time(borealis_data, bounds_voronoi, time = "year")
}

}
