#' Class for the SELECT query.
#'
#' This class represents an SQL SELECT query.
#' See make_select() and make_select_all() factory functions to create more
#' easily a SELECT query.
#'
#' @examples
#' # Here is a simple SELECT * query:
#' select <- QuerySelect$new(select = StmtSelectAll$new(),
#'                           from = StmtFrom$new("books"))
#'
#' @seealso \code{\link{make_select}}, \code{\link{make_select_all}}
#' @import R6
#' @include Query.R
#' @export
QuerySelect <- R6::R6Class("QuerySelect",
  inherit = Query,
  public = list(

    #' @description
    #' Initializer.
    #' @param select A StmtSelect instance.
    #' @param from A StmtFrom instance.
    #' @return Nothing.
    initialize = function(select, from) {
      chk::chk_is(select, "StmtSelect")
      chk::chk_is(from, "StmtFrom")
      super$initialize(c("Select", "From", "Join*", "Where?", "Limit?"))
      self$add(select)
      self$add(from)
      return(invisible(NULL))
    }
  )
)
