% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_dsgn.R
\name{power_dsgn}
\alias{power_dsgn}
\title{Power calculation for multiple panel designs}
\usage{
power_dsgn(
  ind_names,
  ind_values,
  unit_var,
  period_var,
  unitperiod_var,
  index_var,
  unit_rho = 1,
  period_rho = 0,
  paneldsgn,
  nrepeats = NULL,
  trend_type = "mean",
  ind_pct = NULL,
  ind_tail = NULL,
  trend = 2,
  alpha = 0.05
)
}
\arguments{
\item{ind_names}{Vector of indicator names}

\item{ind_values}{Vector of indicator mean values}

\item{unit_var}{Vector of variance component estimates for unit variability
for the indicators}

\item{period_var}{Vector of variance component estimates for period
variability for the indicators}

\item{unitperiod_var}{Vector of variance component estimates for unit by
period interaction variability for the indicators}

\item{index_var}{Vector of variance component estimates for index (residual)
error for the indicators}

\item{unit_rho}{Correlation across units. Default is \code{1}.}

\item{period_rho}{Correlation across periods. Default is \code{0}.}

\item{paneldsgn}{A list of panel designs each as a matrix.  Each element of
the list is a matrix with \code{dimnames} (dimensions: number of panels (rows) by
number of periods (columns)) containing the number of units visited for
each combination of panel and period.  Dimnames for columns must be
able to be coerced into an integer (e.g., 2016).  All designs must span the same
number of periods.  Typically, the panel designs are the output of the
function \code{revisit_dsgn}.}

\item{nrepeats}{Either \code{NULL} or a list of matrices the same length as
\code{paneldsgn} specifying the number of revisits made to units in a panel in the
same period for each design.  Specifying \code{NULL} indicates that number of
revisits to units is the same for all panels and for all periods and for
all panel designs. The default is \code{NULL}, a single visit. Names must match
list names in \code{paneldsgn}.}

\item{trend_type}{Trend type is either \code{"mean"} where trend is applied as
percent trend in the indicator mean or \code{"percent"} where the trend is applied
as percent trend in the proportion (percent) of the distribution that is
below or above a fixed value. Default is \code{trend_type="mean"}}

\item{ind_pct}{When \code{trend_type} is equal to \code{"percent"}, a vector of the
values of the indicator fixed value that defines the percent.  Default is
NULL}

\item{ind_tail}{When trend_type is equal to \code{"percent"}, a character vector
with values of either \code{"lower"} or \code{"upper"} for each indicator.  \code{"lower"}
states that the percent is associated with the lower tail of the
distribution and \code{"upper"} states that the percent is associated with the
upper tail of the distribution. Default is \code{NULL}.}

\item{trend}{Single value or vector of assumed percent change from
initial value in the indicator for each period. Assumes the trend is
expressed as percent per period. Note that the trend may be either positive
or negative. The default is \code{2}.}

\item{alpha}{Single value or vector of significance level for linear
trend test, alpha, Type I error, level.  The default is \code{0.05}.}
}
\value{
A list with components \code{trend_type}, \code{ind_pct}, \code{ind_tail}, trend values
  across periods, periods (all periods included in one or more panel
  designs), significance levels, a five-dimensional array of power
  calculations (dimensions: panel, design names, periods, indicator names,
  trend names, \code{alpha_names}), an array of indicator mean values for each trend
  and the function call.
}
\description{
Calculates the power for trend detection for one or more variables, for one
or more panel designs, for one or more linear trends, and for one or more
significance levels.  The panel designs create a covariance model where the
model includes variance components for units, periods, the interaction of
units and periods, and the residual (or index) variance.
}
\details{
Calculates the power for detecting a change in the mean for
  different panel design structures. The model incorporates unit, period,
  unit by period, and index variance components as well as correlation across
  units and across periods.  See references for methods.
}
\examples{
# Power for rotating panel with sample size 60
power_dsgn("Variable_Name",
  ind_values = 43, unit_var = 280, period_var = 4,
  unitperiod_var = 40, index_var = 90, unit_rho = 1, period_rho = 0,
  paneldsgn = list(NoR60 = revisit_dsgn(20,
    panels = list(NoR60 = list(
      n = 60, pnl_dsgn = c(1, NA),
      pnl_n = NA, start_option = "None"
    )), begin = 1
  )),
  nrepeats = NULL, trend_type = "mean", trend = 1.0, alpha = 0.05
)
}
\references{
Urquhart, N. S., W. S. Overton, et al. (1993) Comparing sampling designs
  for monitoring ecological status and trends: impact of temporal patterns.
  In: \emph{Statistics for the Environment.} V. Barnett and K. F. Turkman.
  John Wiley & Sons, New York, pp. 71-86.

  Urquhart, N. S. and T. M. Kincaid (1999). Designs for detecting trends
  from repeated surveys of ecological resources. \emph{Journal of
  Agricultural, Biological, and Environmental Statistics}, \bold{4(4)},
  404-414.

  Urquhart, N. S. (2012). The role of monitoring design in detecting trend in
  long-term ecological monitoring studies. In: \emph{Design and Analysis of
  Long-term Ecological Monitoring Studies.} R. A. Gitzen, J. J. Millspaugh,
  A. B. Cooper, and D. S. Licht (eds.). Cambridge University Press, New York,
  pp. 151-173.
}
\seealso{
\describe{
    \item{\code{\link{ppd_plot}}}{ to plot power curves for
      panel designs}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
