% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sample_mixture.R
\name{draw_sample_mixture}
\alias{draw_sample_mixture}
\title{Draw Samples from a Gaussian Mixture Distribution}
\usage{
draw_sample_mixture(k_groups, f, max_n, counter_n = 100, verbose = FALSE)
}
\arguments{
\item{k_groups}{number of groups (levels of factor_A)}

\item{f}{Cohen's f. The simulated effect size.}

\item{max_n}{sample size for the groups (total sample size = max_n*k_groups)}

\item{counter_n}{number of times the function tries to find a possible parameter combination for the distribution. Default value is set to 100.}

\item{verbose}{\code{TRUE} or \code{FALSE.} Print out more information about the internal process of sampling the parameters
(the internal counter that was reached, some additional hints and the drawn parameters for the Gaussian Mixture distributions.)}
}
\value{
returns a data.frame with the columns y (observations) and x (factor_A).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Draws exemplary samples with a certain effect size for the sequential one-oway ANOVA or the sequential t-test, see Steinhilber et al. (2023) \url{doi:10.31234/osf.io/m64ne}
}
\examples{
set.seed(333)

data <- sprtt::draw_sample_mixture(
  k_groups = 2,
  f = 0.40,
  max_n = 2
)
data

data <- sprtt::draw_sample_mixture(
  k_groups = 4,
  f = 1.2, # very large effect size
  max_n = 4,
  counter_n = 1000, # increase of counter is necessary
  verbose = TRUE # prints more information to the console
)
data
}
