% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotifyr.R
\docType{package}
\name{spotifyr}
\alias{spotifyr-package}
\alias{spotifyr}
\title{\code{spotifyr} package}
\description{
A Quick and Easy Wrapper for Pulling Track Audio Features from Spotify's Web API in Bulk
}
\details{
See the README on
\href{https://github.com/charlie86/spotifyr#readme}{GitHub}
}
\section{artist functions}{

Retrieve information related to artists.
\code{\link{get_artist}}: Get the data of a single artist.\cr
\code{\link{get_artists}}: Get the data of multiple artist.\cr
\code{\link{get_related_artists}}: Get that of related artist to an original artist.\cr
\code{\link{get_artist_albums}}: Get artists who appear on an album.\cr
}

\section{track functions}{

Retrieve information related to individual song recordings (songs, concerts).
\code{\link{get_track}} \cr
\code{\link{get_tracks}} \cr
\code{\link{get_playlist_tracks}} \cr
}

\section{album functions}{

Retrieve information about albums.
See also \code{\link{get_album_tracks}}.
}

\section{playlist functions}{

Work with playlists.\cr
\code{\link{add_tracks_to_playlist}} \cr
\code{\link{change_playlist_details}} \cr
\code{\link{get_user_playlists}} \cr
}

\section{player functions}{

Interact with the user's devices and players.
}

\section{personalization functions}{

\code{\link{get_my_top_artists_or_tracks}}
}

\section{musicology functions}{

Functions related to the contents of the music.\cr
\code{\link{get_track_audio_analysis}} \cr
\code{\link{get_artist_audio_features}} \cr
\code{\link{get_playlist_audio_features}} \cr
\code{\link{get_user_audio_features}}\cr
\code{\link{get_genre_artists}} \cr
}

\section{search functions}{

Search for an artist, song or other keyword.\cr
The main function is \code{\link{search_spotify}}.
}

\section{authentication functions}{

Helper functions to provide authentication function for requests.
Never reveal in public documents, markdown files the returned values of these
functions: \cr
\code{\link{get_spotify_authorization_code}} \cr
\code{\link{get_spotify_access_token}}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/charlie86/spotifyr}
  \item Report bugs at \url{https://github.com/charlie86/spotifyr/issues}
}

}
\author{
\strong{Maintainer}: Daniel Antal \email{daniel.antal@dataobservatory.eu} (\href{https://orcid.org/0000-0001-7513-6760}{ORCID})

Authors:
\itemize{
  \item Charlie Thompson \email{chuck@rcharlie.com}
  \item Josiah Parry \email{josiah.parry@yahoo.com} (\href{https://orcid.org/0000-0001-9910-865X}{ORCID})
  \item Donal Phipps \email{donal.phipps@gmail.com}
  \item Tom Wolff \email{tom.wolff@duke.edu}
}

Other contributors:
\itemize{
  \item Stephen Holsenbeck [contributor]
  \item Peter Harrison [contributor]
}

}
