% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{construct.generalised.design.matrix}
\alias{construct.generalised.design.matrix}
\title{Construct the generalised Bradley--Terry design matrix}
\usage{
construct.generalised.design.matrix(player1, player2, formula, data)
}
\arguments{
\item{player1}{vector containing the labels of player1}

\item{player2}{vector containing the labels of player2}

\item{formula}{right-hand-side only formula for the player specific covariates}

\item{data}{dataframe containing the values of the player specific covariates}
}
\value{
design matrix X
}
\description{
Construct the generalised Bradley--Terry design matrix
}
\examples{

#Generate data.frame
example.df <- data.frame("a" = stats::runif(100, 0, 3),
                    "b" = sample(1:2, 100, TRUE))

#Generate formula
example.formula <- ~  a + b + I(a^2)

#Generate comparisons of three players
player1 <- c(1, 3, 2, 1)
player2 <- c(3, 1, 1, 2)
X <- construct.generalised.design.matrix(player1, player2, example.formula, example.df)

}
\keyword{internal}
