% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sped.R
\name{sped}
\alias{sped}
\title{Smoothness-Penalized Deconvolution}
\usage{
sped(
  Y,
  gtwid,
  alpha,
  constraint = "constrainedQP",
  spline_dim = 30,
  hn = NULL,
  ephemera = NULL,
  ...
)
}
\arguments{
\item{Y}{Numeric vector of data from the model \eqn{Y = X + Z}}

\item{gtwid}{Object of class \link[=new_spedecon_gtwid]{spedecon_gtwid} describing the density of \eqn{Z} in the model \eqn{Y = X + Z}. It should almost always be created by one of the helper functions \code{\link[=gaussian_gtwid]{gaussian_gtwid()}}, \code{\link[=laplace_gtwid]{laplace_gtwid()}}, or \code{\link[=uniform_gtwid]{uniform_gtwid()}}.}

\item{alpha}{Positive numeric penalty parameter}

\item{constraint}{String, controls whether and how the solution is constrained to be a pdf. One of \code{"constrainedQP"}, \code{"projection"}, or \code{"unconstrained"} for constrained quadratic program, metric projection, or unconstrained, respectively}

\item{spline_dim}{Numeric integer, dimension of spline space}

\item{hn}{(optional) Object of class \code{histogram} holding pre-computed histogram computed from the data \eqn{Y}}

\item{ephemera}{(optional) Object of class \code{spedecon_ephemera} holding pre-computed computational bits}

\item{...}{(optional) Other arguments}
}
\value{
Object of class \link[=new_spedecon_spline_sped_fit]{spedecon_spline_sped_fit}
}
\description{
\code{sped()} computes the Smoothness-Penalized Deconvolution estimate on the provided data and error distribution
}
\details{
This function computes the "Smoothness-Penalized Deconvolution" (SPeD) estimate of a density under additive measurement error.
The essential inputs to the function are the data \code{Y}, the Fourier transform \code{gtwid} of the error density, and the penalty parameter \code{alpha}; more details follow here, but for a full description of the estimator please consult Kent and Ruppert (2023).

The data model is that we observe an iid sample distributed like \eqn{Y = X + Z}, with \eqn{Z} an error independent of \eqn{X}.
We wish to estimate the density \eqn{f(x)} of \eqn{X}.
It is assumed that we know the probability density of the errors \eqn{Z}, call it \eqn{g(z)}.

The estimator begins with a density estimate \eqn{h_n(y)}{hₙ(y)} of the density of \eqn{Y}, and minimizes the objective function
\deqn{\|g*v - h_n\|^2 + \alpha \|v^{(2)}\|^2}{‖g*v - hₙ‖² + α‖v⁽²⁾‖²}
in \eqn{v}, with \eqn{v} ranging over a space of cubic splines with equally-spaced knots; the dimension of this space can be adjusted with the argument \code{spline_dim}.
The SPeD estimate is not naturally a pdf, so it must be constrained.
When \code{constraint = "constrainedQP"}, the constraint is imposed directly into quadratic program minimizing the objective; when \code{constraint = "projection"}, the unconstrained estimate is computed and then projected onto the space of pdfs.
The preliminary density estimate \eqn{h_n}{hₙ} is computed internally as a histogram using Freedman-Diaconis choice of bin width, but a user-supplied histogram computed with \code{\link[=hist]{hist()}} may be provided via the \code{hn} argument.

The computations require the \emph{Fourier transform} \eqn{\tilde g(t)}{gtwid} of the probability density, and this must be supplied as an object of type \code{spedecon_gtwid}, which can be produced for common error densities using the helper functions \code{\link[=gaussian_gtwid]{gaussian_gtwid()}}, \code{\link[=laplace_gtwid]{laplace_gtwid()}}, and \code{\link[=uniform_gtwid]{uniform_gtwid()}}.

If the estimator will be re-computed many times for many realizations of data, substantial time can be saved by pre-computing all the auxiliary matrices and vectors one time, and supplying them through the \code{ephemera} argument.
This can be done whenever the repeated computations all use the same error density, same histogram bins, and same spline space, as those are what define the required matrices and vectors.
A helper function \code{\link[=compute_ephemera]{compute_ephemera()}} is provided to pre-compute these.
}
\examples{
alpha <- 1e-3
n <- 1e3; s <- 0.3
Y <- rgamma(n,5,2) + rnorm(n,0,s) # Data, contaminated with Gaussian errors
sol <- sped(Y,gtwid=gaussian_gtwid(sd=s),1e-3)
plot(sol,n=1e3) # Plot the resulting estimate
curve(dgamma(x,5,2),col=2,n=1e3,add=TRUE) # The target density f() of X
sol(c(2,3,4)) # We can evaluate sol; it is a function
}
\references{
Kent D, Ruppert D (2023). “Smoothness-Penalized Deconvolution (SPeD) of a Density Estimate.” \emph{Journal of the American Statistical Association}, to appear. ISSN 0162-1459, \doi{10.1080/01621459.2023.2259028}
}
