% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomaly_score.R
\name{anomaly_score}
\alias{anomaly_score}
\title{Create anomaly score from input data}
\usage{
anomaly_score(x, score_window, spec_window = 3, m = 5)
}
\arguments{
\item{x}{Numeric vector.}

\item{score_window}{Integer value for the window width for scoring.}

\item{spec_window}{Positive integer value for the window to calculate the averaged log spectrum.}

\item{m}{Integer value representing the number of preceding points for the estimation.}
}
\value{
A numeric vector of anomaly scores.
}
\description{
Convert an input of numeric data, typically a time series, into a score for anomaly detection.
The data is first extended to improve the detection latency, followed by saliency map creation. The
score is calculated using the sliding window average for each point in the saliency map.
}
\examples{
tmp <- ts(rnorm(12*6,10,2), start=c(2009, 1), end=c(2014, 12), frequency=12)
anomaly_score(tmp, score_window = 25)
}
