% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R
\name{generate_bounds}
\alias{generate_bounds}
\title{Generates the intervals based on the survival times in the supplied data set 
using the quantile function.}
\usage{
generate_bounds(
  train_data,
  time_col,
  event_col,
  suggested_intervals,
  obs_window
)
}
\arguments{
\item{train_data}{A survival data set containing at least three columns - one which
matches the string in the `time_col` parameter, one which matches the string in the 
`event_col` parameter, and at least one covariate column for modeling.}

\item{time_col}{The name of the column in `train_data` containing survivial time}

\item{event_col}{The name of the column in `train_data` contaiing the event indicator. 
Values in this column must be either zero (0) or one (1)}

\item{suggested_intervals}{The number of intervals to create. If the number of events
in the data is less than `suggested_intervals`, it is ignored.}

\item{obs_window}{An artificial censoring time. Any observations in `train_data` beyond
this time will be administratively censored.}
}
\value{
A list of upper an lower bounds for each generated interval.
}
\description{
Generates the intervals based on the survival times in the supplied data set 
using the quantile function.
}
\examples{
df <- data.frame(a=c(1,2,3,4,5,6), surv_time=c(1,4,5,6,8,9), event=c(1,1,1,1,0,1))
bounds <- generate_bounds(df, time_col="surv_time", event_col="event", 
                          suggested_intervals=3, obs_window=8)
                          
}
\seealso{
[create_person_period_data()]
}
\author{
Stephen Abrams, \email{stephen.abrams@louisville.edu}
}
\keyword{utilities}
