% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.r
\name{summary.specr.setup}
\alias{summary.specr.setup}
\title{Summarizing the Specifications Setup}
\usage{
\method{summary}{specr.setup}(object, digits = 2, rows = 6, print.specs = TRUE, ...)
}
\arguments{
\item{object}{An object of class "specr.setup", usually, a result of a call to \code{setup}.}

\item{digits}{The number of digits to use when printing the specification table.}

\item{rows}{The number of rows of the specification tibble that should be printed.}

\item{print.specs}{Logical value; if \code{TRUE}, a head of the specification tibble
is returned and printed.}

\item{...}{further arguments passed to or from other methods (currently ignored).}
}
\value{
A printed summary of an object of class \code{specr.setup}.
}
\description{
\code{summary} method for class "specr.setup". Provides a short summary of the
created specifications (the "multiverse") that lists all analytic choices, prints
the function used to extract the parameters from the model. Finally, if
\code{print.specs = TRUE}, it also shows the head of the actual specification grid.
}
\examples{
# Setup specifications
specs <- setup(data = example_data,
  x = c("x1", "x2"),
  y = c("y1", "y2"),
  model = c("lm", "glm"),
  controls = c("c1", "c2", "c3"),
  subsets = list(group3 = unique(example_data$group3)))

# Summarize specifications
summary(specs)
}
\seealso{
The function \code{\link[=setup]{setup()}}, which creates the "specr.setup" object.
}
