% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{speckle_ps}
\alias{speckle_ps}
\title{Power spectrum calculation}
\usage{
speckle_ps(filename, dark, flat, threshold = 50000L)
}
\arguments{
\item{filename}{a character string with the path name to a file.}

\item{dark}{512 x 512 middle frame matrix.}

\item{flat}{512 x 512 middle flat field matrix.}

\item{threshold}{an integer (default is 50000).}
}
\value{
The 513 x 1024 double matrix of power spectrum.
}
\description{
Power spectrum of the series of 512 x 512 speckle images
}
\examples{
obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
midd_dark <- matrix(0, 512, 512)
midd_flat <- matrix(1, 512, 512)
pow_spec <- speckle_ps(obj_filename, dark = midd_dark, flat = midd_flat)
}
