% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{sim_sar}
\alias{sim_sar}
\title{Simulate Spatial Lag Model (SAR)}
\usage{
sim_sar(u, xb, listw, rho = 0.5)
}
\arguments{
\item{u}{an error vector}

\item{xb}{predicted x values as calculated by \code{make_xb()}}

\item{listw}{a \code{listw} object generated with \code{sim_grid_listw()}.}

\item{rho}{the spatial autoregressive coefficient for the spatially lagged dependent variable.}
}
\value{
A numeric vector
}
\description{
Simulate y for a SAR model.
}
\examples{
ncol <- 20
n <- ncol^2
listw <- sim_grid_listw(ncol, ncol)  # Create spatial weights for a grid
u <- make_error(n)  # Simulate random errors
x <- make_x(
  n,
  mu = c(0.25, 5),
  var = c(1, 0.75),
  method = "normal"
)  # Generate x variables

# create xb with intercept = 1, beta1 = 2, beta2 = -3
xb <- make_xb(x, c(1, 2, -3))
y <- sim_sar(u, xb, listw)

# combine data 
df <- cbind(y = y, x)

# fit SAR model
# Note lambda, x_1, and x_2 estimates.
spatialreg::stsls(y ~ ., df, listw)
}
\references{
\href{https://pysal.org/spreg/generated/spreg.dgp.dgp_lag.html#spreg.dgp.dgp_lag}{\code{spreg.dgp.dgp_lag}}
}
