% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{make_error}
\alias{make_error}
\title{Simulate an error term}
\usage{
make_error(
  n = 10,
  mu = 0,
  var = 1,
  method = c("normal", "laplace", "cauchy", "lognormal")
)
}
\arguments{
\item{n}{the number of values to simulate.}

\item{mu}{the sample average.}

\item{var}{the sample variance. The \code{sqrt(var)} is passed to \code{rnorm()} and \code{rlnorm()} for normal and laplace distributions.
\code{sqrt(var / 2)} is used for \code{laplace()} .}

\item{method}{must be one of \code{"normal"}, \code{"laplace"}, \code{"cauchy"}, or \code{"lognormal"}.}
}
\value{
A numeric vector
}
\description{
Simulate an error term
}
\details{
\itemize{
\item \code{"normal"}: fit with \code{rnorm()}
\item \code{"laplace"}: fit with \code{smoothmest::rdoublex()}
\item \code{"cauchy"}: fit with \code{rcauchy()}
\item \code{"lognormal"}: fit with \code{rlnorm()}
}
}
