% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{raw_moran}
\alias{raw_moran}
\title{Spatial correlation at lag 1}
\usage{
raw_moran(mat)
}
\arguments{
\item{mat}{A matrix containing logical, numeric or integer values}
}
\value{
The Moran's I numeric value as a numeric number.
}
\description{
This function computes the Moran's I index of spatial 
  correlation at lag 1.
}
\details{
This function returns the spatial correlation as measured by 
  the Moran's I index. If the variance of the matrix is zero, then 
  \code{NaN} is returned. This function assumes a 4-way neighborhood (a.k.a. 
  von-Neumann neighborhood), and does not wrap around at the sides of the matrix.
}
\examples{

# Spatial correlation of white noise is close to zero
rmat <- matrix(runif(1000) > .5, ncol = 100)
raw_moran(rmat) 

# Spatial correlation of a half-ones / half-zeros matrix is close to one. 
# This would produce close but inaccurate results in version <3.0.2
m <- cbind(matrix(1, nrow = 100, ncol = 50), 
           matrix(0, nrow = 100, ncol = 50))

raw_moran(m)

}
\seealso{
\code{\link{generic_sews}}
}
