% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.nb.gf.r
\name{test.nb.gf}
\alias{test.nb.gf}
\title{Testing Hypotheses in Gamma Frailty models}
\source{
\code{test.nb.gf} uses code contributed by Thomas Asendorf.
}
\usage{
test.nb.gf(
  dataC,
  dataE,
  h,
  hgrad,
  h0 = 0,
  trend = c("constant", "exponential", "custom"),
  H0 = FALSE,
  one.sided = TRUE,
  ...
)
}
\arguments{
\item{dataC}{a matrix or data frame containing count data from the control group. Columns correspond to time points, rows to observations.}

\item{dataE}{a matrix or data frame containing count data from the experiment group. Columns correspond to time points, rows to observations.}

\item{h}{hypothesis to be tested. The function must return a single value when evaluated on lambda.}

\item{hgrad}{gradient of function h}

\item{h0}{the value against which h is tested, see 'Details'.}

\item{trend}{the trend which assumed to be underlying in the data.}

\item{H0}{indicates if the sandwich estimator is calculated under the null hypothesis or alternative.}

\item{one.sided}{indicates if the hypothesis should be tested one- or two-sided}

\item{...}{Arguments to be passed to function \code{fit.nb.gf()}.}
}
\value{
\code{test.nb.gf} returns effect size, standard error, Z-statistic and p-value attained through standard normal approximation.
}
\description{
\code{test.nb.gf} tests hypotheses for certain trends in Gamma frailty models
}
\details{
the function \code{test.nb.gf} tests for the null hypothesis \eqn{h(\eta, \lambda) = h_0} against the alternative \eqn{h(\eta, \lambda) \neq h_0}.
The fitting function allows for incomplete follow up, but not for intermittent missingness.

If parameter H0 is set to TRUE, the hessian and outer gradient are calculated under the assumption that \code{lambda[2]} \eqn{\geq} \code{h0} if
\code{trend = "constant"} or \code{lambda[3]} \eqn{\geq} \code{h0} if \code{trend = "exponential"}.
}
\examples{
#Create data from two groups
random<-get.groups(n=c(100,100), size=c(0.7, 0.7), lambda=c(0.8, 0), rho=c(0.6, 0.6),
  tp=7, trend="constant")

#Define hypothesis
h<-function(lambda.eta){
  lambda.eta[2]
}
hgrad<-function(lambda.eta){
  c(0, 1, 0)
}
test.nb.gf(dataC=random[101:200,], dataE=random[1:100,], h=h, hgrad=hgrad, h0=0,
  trend="constant", H0=FALSE)
}
\references{
Fiocco M, Putter H, Van Houwelingen JC, (2009), A new serially correlated gamma-frailty process for longitudinal count data \emph{Biostatistics} Vol. 10, No. 2, pp. 245-257.
}
\seealso{
\code{\link{rnbinom.gf}} for information on the Gamma Frailty model, \code{\link{n.nb.gf}} for calculating
initial sample size required when performing inference, \code{\link{fit.nb.gf}} for calculating
initial parameters required when performing sample size estimation.
}
