% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnbinom.gf.r
\name{rnbinom.gf}
\alias{rnbinom.gf}
\title{Generate Time Series with Negative Binomial Distribution and Multivariate Gamma Frailty with Autoregressive Correlation Structure of Order One}
\source{
\code{rnbinom.gf} computes observations from a Gamma frailty model by \emph{Fiocco et. al. 2009} using code contributed by Thomas Asendorf.
}
\usage{
rnbinom.gf(n, size, mu, rho, tp)
}
\arguments{
\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{size}{dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{mu}{vector of means of time points: see 'Details'.}

\item{rho}{correlation coefficient of the underlying autoregressive Gamma frailty. Must be between 0 and 1.}

\item{tp}{number of observed time points.}
}
\value{
\code{rnbinom.gf} returns a matrix of dimension \code{n} x \code{tp} with marginal negative binomial
distribution with means \code{mu}, common dispersion parameter \code{size} and a correlation induce by the autoregressive
multivariate Gamma frailty.
}
\description{
\code{rnbinom.gf} generates one or more independent time series following the Gamma frailty model. The generated data has negative binomial marginal distribution and the underlying multivariate Gamma frailty an autoregressive covariance structure.
}
\details{
The generated marginal negative binomial distribution with mean \code{mu} = \eqn{\mu} and \code{size} = \eqn{\eta} has density
\deqn{(\mu/(\mu+\eta))^x \Gamma(x + \eta)/(\Gamma(x+1)\Gamma(\eta)) (\eta/(\mu+\eta))^\eta}
for \eqn{0 < \mu}, \eqn{0 < \eta} and \eqn{x=0, 1, 2, ...}. Hereby, each entry of vector \code{mu} corresponds to
one time point. Therefore, each timepoint can have its distinct mean.

Within the Gamma frailty model, the correlation between two frailties of time points \eqn{t} and \eqn{s} for \code{rho} = \eqn{\rho} is given by
\deqn{\rho^|t-s|}
for \eqn{0 \le \rho \le 1}. Note: this does not correspond to the correlation of observations.
}
\examples{
set.seed(8)
random<-rnbinom.gf(n=1000, size=0.6, mu=1:6, rho=0.8, tp=6)
cor(random)

#Check the marginal distribution of time point 3
plot(table(random[,3])/1000, xlab="Probability", ylab="Observation")
lines(0:26, dnbinom(0:26, mu=3, size=0.6), col="red")
legend("topright",legend=c("Theoretical Marginal Distribution", "Observed Distribution"),
  col=c("red", "black"), lty=1, lwd=c(1,2))

}
\references{
Fiocco M, Putter H, Van Houwelingen JC, (2009), A new serially correlated gamma-frailty process for longitudinal count data \emph{Biostatistics} Vol. 10, No. 2, pp. 245-257.
}
